#include <cstdio>
#include <cassert>
#include <cstring>
#include <algorithm>
#include <iostream>
#include <ctime>
#include <unistd.h>
#include <vector>
#include <set>
#include <queue>
#include <string>

using namespace std;

#define FOR(i, a, b) for (int i=(a); i<(b); i++)
#define REP(i, n) FOR(i, 0, n)
#define X first
#define Y second

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long ll;
typedef pair<int, int> P;

const int MAXN = 500100;

vector <int> V[MAXN];
int p[MAXN];
int pos[MAXN], nval[MAXN];
int dokle[MAXN], dva[MAXN], do_kraja[MAXN];
int n, q;

void load() {
  scanf("%d%*d%d", &n, &q);

  p[0] = p[1] = MAXN - 2;
  REP(i, n)
    scanf("%d", &p[i+2]);

  p[n+2] = p[n+3] = MAXN - 1;
  n += 4;

  REP(i, n)
    V[p[i]].push_back(i);

  REP(i, q) {
    scanf("%d%d", &pos[i], &nval[i]); pos[i]++;
  }
}

void gen_dokle() {
  int indv[MAXN];
  REP(i, MAXN) indv[i] = (int) V[i].size()-1;

  do_kraja[n] = 0;
  dva[n] = n;
  dokle[n] = n; 
  for (int i=n-1; i>=0; i--) {
    dokle[i] = dokle[i+1];
    dva[i] = dva[i+1];
    if (indv[p[i]] != (int) V[p[i]].size()-1) {
      dokle[i] = min(dokle[i], V[p[i]][indv[p[i]]+1]);
      dva[i] = min(dva[i], max(dokle[i+1], V[p[i]][indv[p[i]]+1]));
    }
    
    indv[p[i]]--;
    do_kraja[i] = do_kraja[dokle[i]] + 1;    
  }
}

int pocetak[MAXN], kolko_do_mene[MAXN];
void gen_greedy() {
  for (int i=0, klk=1; i<n; i=dokle[i], klk++) {
    FOR(j, i, dokle[i]) {
      pocetak[j] = i;
      kolko_do_mene[j] = klk;
    }
  }
}

int prviy(int ps, int val) {
  auto it = lower_bound(V[val].begin(), V[val].end(), ps);
  if (it == V[val].end()) return n;
  return *it;
}

int main() {
  load();
  gen_dokle();
  gen_greedy();

  REP(i, q) {
    int kamo, skolko, ps = pos[i], val = nval[i];
    int A = pocetak[ps];    

    if (p[ps] == val)
      kamo = skolko = 0;
    else if (A == ps) {
      int prosli = pocetak[ps-1];
      kamo = min(dva[prosli], max(prviy(prosli, val), ps));
      skolko = kolko_do_mene[prosli];
    }
    else if (p[ps] == p[dokle[A]]) {
      kamo = min(dva[A], max(ps, prviy(A, val)));
      skolko = kolko_do_mene[A];
    }
    else {
      kamo = min(dokle[A], max(ps, prviy(A, val)));
      skolko = kolko_do_mene[A];
    }

    if (kamo == ps) {
      if (p[ps] == p[dokle[ps]])
	kamo = min(dva[ps], prviy(ps, val));
      else
	kamo = min(dokle[ps], prviy(ps, val));
      
      skolko++;
    }      
    
    int ret = skolko + do_kraja[kamo] - 2;
    printf("%d\n", ret);
  }
  
  return 0;
}
